/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public abstract class BlueprintTreeFeature
extends Feature<TreeConfiguration> {
    public Set<BlockPos> logPositions;
    public Set<BlockPos> foliagePositions;
    public HashMap<BlockPos, BlockState> specialLogPositions;
    public HashMap<BlockPos, BlockState> specialFoliagePositions;
    public boolean placeDirt;

    public BlueprintTreeFeature(Codec<TreeConfiguration> config) {
        this(true, config);
    }

    public BlueprintTreeFeature(boolean placeDirt, Codec<TreeConfiguration> config) {
        super(config);
        this.placeDirt = placeDirt;
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        this.logPositions = Sets.newHashSet();
        this.foliagePositions = Sets.newHashSet();
        this.specialLogPositions = Maps.newHashMap();
        this.specialFoliagePositions = Maps.newHashMap();
        if (this.canSurvive(level, origin)) {
            this.doPlace(context);
            for (BlockPos logPos2 : this.logPositions) {
                if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)logPos2) && logPos2.m_123342_() <= level.m_151558_()) continue;
                return false;
            }
            for (BlockPos foliagePos2 : this.foliagePositions) {
                if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)foliagePos2) && foliagePos2.m_123342_() <= level.m_151558_()) continue;
                return false;
            }
            this.doMidPlace(context);
            this.logPositions.forEach(logPos -> {
                level.m_7731_(logPos, this.specialLogPositions.getOrDefault(logPos, config.f_68185_.m_213972_(random, logPos)), 19);
                if (logPos.m_123342_() == origin.m_123342_() && this.placeDirt) {
                    BlueprintTreeFeature.setDirtAt(level, random, logPos.m_7495_(), config);
                }
            });
            this.foliagePositions.forEach(foliagePos -> {
                if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)foliagePos)) {
                    BlockState state = this.specialFoliagePositions.getOrDefault(foliagePos, config.f_161213_.m_213972_(random, foliagePos));
                    if (TreeFeature.m_67282_((LevelSimulatedReader)level, (BlockPos)foliagePos) && state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    }
                    if (!state.m_60795_()) {
                        level.m_7731_(foliagePos, state, 19);
                    }
                }
            });
            HashSet decorationPositions = Sets.newHashSet();
            BiConsumer<BlockPos, BlockState> decorationSetter = (decorationPos, state) -> {
                decorationPositions.add(decorationPos.m_7949_());
                level.m_7731_(decorationPos, state, 19);
            };
            if (!config.f_68187_.isEmpty()) {
                TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)level, decorationSetter, random, this.logPositions, this.foliagePositions, (Set)Sets.newHashSet());
                config.f_68187_.forEach(decorator -> decorator.m_214187_(decoratorContext));
            }
            this.doPostPlace(context);
            return BoundingBox.m_162378_((Iterable)Iterables.concat(this.logPositions, this.foliagePositions, (Iterable)decorationPositions)).map(boundingBox -> {
                DiscreteVoxelShape shape = TreeFeature.m_225251_((LevelAccessor)level, (BoundingBox)boundingBox, this.logPositions, (Set)decorationPositions, Set.of());
                StructureTemplate.m_74510_((LevelAccessor)level, (int)3, (DiscreteVoxelShape)shape, (int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public abstract BlockState getSapling();

    public boolean canSurvive(WorldGenLevel level, BlockPos pos) {
        return this.getSapling().m_60710_((LevelReader)level, pos);
    }

    public abstract void doPlace(FeaturePlaceContext<TreeConfiguration> var1);

    public void doMidPlace(FeaturePlaceContext<TreeConfiguration> context) {
    }

    public void doPostPlace(FeaturePlaceContext<TreeConfiguration> context) {
    }

    public void addLog(BlockPos pos) {
        this.logPositions.add(pos.m_7949_());
    }

    public void addAxisLog(BlockPos pos, Direction.Axis axis, TreeConfiguration config, RandomSource random) {
        BlockState state = config.f_68185_.m_213972_(random, pos);
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            this.addSpecialLog(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis));
        } else {
            this.addLog(pos);
        }
    }

    public void addAxisLog(BlockPos pos, Direction direction, TreeConfiguration config, RandomSource random) {
        this.addAxisLog(pos, direction.m_122434_(), config, random);
    }

    public void addSpecialLog(BlockPos pos, BlockState state) {
        this.addLog(pos);
        this.specialLogPositions.put(pos.m_7949_(), state);
    }

    public void addFoliage(BlockPos pos) {
        this.foliagePositions.add(pos.m_7949_());
    }

    public void addSpecialFoliage(BlockPos pos, BlockState state) {
        this.addFoliage(pos);
        this.specialFoliagePositions.put(pos.m_7949_(), state);
    }

    public static void setDirtAt(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfiguration config) {
        if (config.f_161215_ || level.m_7433_(pos, state -> state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_))) {
            level.m_7731_(pos, config.f_161212_.m_213972_(random, pos), 19);
        }
    }
}

